<?php
  BEvent::Hook('format comment: html', array('HtmlCleaner', 'Clean'));
  BEvent::HookInstanceOf('HtmlCleaner', 'Legend', 'comment markup legend: html');

  BConfig::$strings['markup: html'] = 'Limited set of HTML tags is allowed (<em>%s</em>).';

/* one-shot */
  $this->name = 'html comments';
  $this->Caption('HTML comments');
  $this->Caption('HTML-комментарии', 'ru');

/* install HtmlCleaner */

/*
  This is a standalone class to sanitize and clean HTML coming from user.
  Released as a part of UverseWiki's blog template; $Rev: 426 $
  For documentation, examples and other information please visit:
  http://proger.i-forge.net/HtmlCleaner and http://uverse.i-forge.net/blog/plugins
*/

class HtmlCleaner {
  public $maxAttrLength = 80;   // e.g. <img src="LENGTH HERE" />
  // 'tag' => mode; mode: array('allowed attr', 'attr'...) OR 'replace with tag' OR
  // true (allow) OR anything == false (disallow).
  // '.tag' => mode - for singule XHTML tags (e.g .<img />).
  public $tags = array(
    'a' => array('href'), 'b' => 'strong', 'big' => true, 'blockquote' => true,
    'center' => true, 'cite' => true, 'i' => 'em', '.img' => array('src'),
    'code' => true, 's' => 'del', 'pre' => true, 'small' => true, 'sub' => true,
    'sup' => true, 'u' => 'ins', '.hr' => true, 'strong' => true, 'em' => true,
    'del' => true, 'ins' => true
  );

  // 1 char only (are passed to strtr()).
  public $opMask = "\1";
  public $edMask = "\2";

  protected $maskRegexps = array();

  static function Clean($html, $addBreaks = true) {
    $obj = new self;
    return $obj->CleanHTML($html, $addBreaks);
  }

  function &CleanHTML($html, $addBreaks = true) {
    $regexps = $this->MaskRegExps();
    $html = preg_replace(array_keys($regexps), array_values($regexps), $html);

    $html = htmlspecialchars($html, ENT_NOQUOTES, 'UTF-8');
    $html = strtr($html, $this->opMask.$this->edMask, '<>');

    $addBreaks and $html = nl2br($html);
    return $html;
  }

    function MaskRegExps() {
      $maskRegexps = &$this->maskRegexps;

      if (!$maskRegexps) {
          $op = $this->opMask;
          $ed = $this->edMask;

        $allowSingle = $allowTags = array();
        foreach (array_filter($this->tags) as $tag => $mode) {
          $isSingle = $tag[0] === '.';
          $isSingle and $tag = ltrim($tag, '.');

          if ($mode === true) {
            $isSingle ? $allowSingle[] = $tag : $allowTags[] = $tag;
          } else {
            $replaceWith = is_string($mode) ? $mode : $tag;

            if (is_array($mode)) {
              $l = $this->maxAttrLength;
              $attrs = '(?: +(?:'.join('|', $mode).')="[^"]{0,'.$l.'}")*';
            } else {
              $attrs = '';
            }

            if ($isSingle) {
              $maskRegexps["~<$tag($attrs) */>~u"] = "$op$replaceWith\\1 /$ed";
            } else {
              $replace = "$op$replaceWith\\1$ed\\2$op/$replaceWith$ed";
              $maskRegexps["~<$tag($attrs)>(.*)</$tag>~us"] = $replace;
            }
          }
        }

        if ($allowSingle) {
          $maskRegexps['~<('.join('|', $allowSingle).') */>~u'] = "$op\\1 /$ed";
        }
        if ($allowTags) {
          $maskRegexps['~<('.join('|', $allowTags).')>(.*)</\\1>~us'] = "$op\\1$ed\\2$op/\\1$ed";
        }
      }

      return $maskRegexps;
    }

  // returns a user-friendly HTML string explaining which tags are allowed to be used and how.
  function Legend() {
    $tags = array();
    foreach ($this->tags as $tag => $mode) { $tags[ ltrim($tag, '.') ] = $mode; }

    foreach ($tags as $tag => &$mode) {
      if (!is_array($mode)) {
        if (is_string($mode)) {
          unset($tags[$mode]);
          $mode = "$tag/$mode";
        } else {
          $mode = $tag;
        }
      }
    }

    ksort($tags);
    $markupInfo = '';

      foreach ($tags as $tag => $mode) {
        if (is_array($mode)) {
          $markupInfo .= ", &lt;$tag ".join('= ', $mode).'&gt;';
        } else {
          $markupInfo .= ', '.$mode;
        }
      }

    return substr($markupInfo, 2);
  }
}
